/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.save;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerBattleMemoryLegacy;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_4284;
import net.minecraft.class_5218;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class TrainerBattleMemory
extends class_18 {
    private static final int GROUPS = 42;
    private Map<String, Map<UUID, Integer>> defeatedBy = new HashMap<String, Map<UUID, Integer>>();
    private static final List<File> LEGACY_FILES = new ArrayList<File>();

    public static TrainerBattleMemory of(class_2487 tag, class_7225.class_7874 provider) {
        TrainerBattleMemory tbm = new TrainerBattleMemory();
        class_2487 defeats = tag.method_10562("defeats");
        defeats.method_10541().forEach(tid -> {
            HashMap defeatedBy = new HashMap();
            class_2487 defeatsTag = defeats.method_10562(tid);
            defeatsTag.method_10541().forEach(pid -> defeatedBy.put(UUID.fromString(pid), defeatsTag.method_10550(pid)));
            tbm.defeatedBy.put((String)tid, defeatedBy);
        });
        return tbm;
    }

    public static String filePath(String trainerId, Version ver) {
        return TrainerBattleMemory.filePath(trainerId, ver.groups);
    }

    protected static String filePath(String trainerId, int groups) {
        return String.format("%s.trainers.%d.mem", "rctmod", TrainerBattleMemory.groupdId(trainerId, groups));
    }

    protected static int groupdId(String trainerId, int groups) {
        return groups > 0 ? (trainerId.hashCode() & 0xFFFFFF) % groups : 0;
    }

    public void addDefeatedBy(String trainerId, class_1657 player) {
        Integer count = (Integer)this.defeatedBy.getOrDefault(trainerId, Map.of()).get(player.method_5667());
        if (count == null) {
            count = 0;
        }
        if (count < Integer.MAX_VALUE) {
            RCTMod rct = RCTMod.getInstance();
            if (rct.getSeriesManager().getGraph(rct.getTrainerManager().getData(player).getCurrentSeries()).contains(trainerId)) {
                PlayerState.get(player).addDefeat(trainerId);
            }
            this.defeatedBy.computeIfAbsent(trainerId, key -> new HashMap()).put(player.method_5667(), count + 1);
            this.method_80();
        }
    }

    public void setDefeatedBy(String trainerId, class_1657 player, int count) {
        Integer prevCount = this.defeatedBy.computeIfAbsent(trainerId, key -> new HashMap()).put(player.method_5667(), count);
        if (prevCount == null || prevCount != count) {
            RCTMod rct = RCTMod.getInstance();
            if (rct.getSeriesManager().getGraph(rct.getTrainerManager().getData(player).getCurrentSeries()).contains(trainerId)) {
                PlayerState.get(player).setDefeats(trainerId, count);
            }
            this.method_80();
        }
    }

    public int getDefeatByCount(String trainerId, class_1657 player) {
        Integer count = (Integer)this.defeatedBy.getOrDefault(trainerId, Map.of()).get(player.method_5667());
        return count == null ? 0 : count;
    }

    public class_2487 method_75(class_2487 compoundTag, class_7225.class_7874 provider) {
        class_2487 defeatsTag = new class_2487();
        this.defeatedBy.forEach((tid, defeatedBy) -> {
            class_2487 tag = new class_2487();
            defeatedBy.forEach((pid, count) -> tag.method_10569(pid.toString(), count.intValue()));
            defeatsTag.method_10566(tid, (class_2520)tag);
        });
        compoundTag.method_10566("defeats", (class_2520)defeatsTag);
        return compoundTag;
    }

    public static Version getVersion(class_26 dds) {
        return (Version)dds.method_17924(new class_18.class_8645(Version::new, Version::of, class_4284.field_19212), Version.filePath());
    }

    public static void clearLegacyFiles() {
        LEGACY_FILES.forEach(f -> f.delete());
        LEGACY_FILES.clear();
    }

    public static void migrate(MinecraftServer server, TrainerManager tm) {
        class_26 dds = server.method_30002().method_17983();
        Version ver = TrainerBattleMemory.getVersion(dds);
        if (ver.isOutdated()) {
            HashMap<String, TrainerBattleMemory> cache = new HashMap<String, TrainerBattleMemory>();
            HashSet oldPaths = new HashSet();
            tm.getAllData(new String[0]).map(e -> (String)e.getKey()).forEach(tid -> {
                TrainerBattleMemoryLegacy legTbm;
                String path;
                TrainerBattleMemory oldTbm;
                if (ver.groups > 0 && (oldTbm = (TrainerBattleMemory)dds.method_20786(new class_18.class_8645(() -> {
                    throw new IllegalStateException("nope");
                }, TrainerBattleMemory::of, class_4284.field_19212), path = TrainerBattleMemory.filePath(tid, ver))) != null) {
                    oldTbm.defeatedBy.forEach((tid2, defeatedBy) -> {
                        ModCommon.LOG.info(String.format("migrating trainer data: v%02d -> v%02d, %s", ver.groups, 42, tid2));
                        TrainerBattleMemory newTbm = cache.computeIfAbsent(TrainerBattleMemory.filePath(tid2, 42), t -> new TrainerBattleMemory());
                        newTbm.defeatedBy.put((String)tid2, (Map<UUID, Integer>)defeatedBy);
                        newTbm.method_80();
                    });
                    oldPaths.add(path);
                    dds.method_123(path, null);
                }
                if ((legTbm = (TrainerBattleMemoryLegacy)dds.method_20786(new class_18.class_8645(() -> {
                    throw new IllegalStateException("nope");
                }, TrainerBattleMemoryLegacy::of, class_4284.field_19212), path = TrainerBattleMemoryLegacy.filePath(tid))) != null) {
                    ModCommon.LOG.info(String.format("migrating trainer data: legacy -> v%02d, %s", 42, tid));
                    TrainerBattleMemory newTbm = cache.computeIfAbsent(TrainerBattleMemory.filePath(tid, 42), t -> new TrainerBattleMemory());
                    newTbm.defeatedBy.put((String)tid, legTbm.defeatedBy);
                    newTbm.method_80();
                    oldPaths.add(path);
                    dds.method_123(path, null);
                }
            });
            cache.forEach((path, tbm) -> dds.method_123(path, (class_18)tbm));
            oldPaths.removeAll(cache.keySet());
            oldPaths.forEach(path -> LEGACY_FILES.add(Paths.get(server.method_27050(class_5218.field_24188).toString(), "data", path + ".dat").toFile()));
            ver.update();
        }
    }

    public static class Version
    extends class_18 {
        private int groups;

        private static String filePath() {
            return String.format("%s.trainers.ver", "rctmod");
        }

        private static Version of(class_2487 tag, class_7225.class_7874 provider) {
            Version ver = new Version();
            ver.groups = tag.method_10550("groups");
            return ver;
        }

        public boolean isOutdated() {
            return this.groups != 42;
        }

        public void update() {
            this.groups = 42;
            this.method_80();
        }

        public class_2487 method_75(class_2487 tag, class_7225.class_7874 provider) {
            tag.method_10569("groups", this.groups);
            return tag;
        }

        public int hashCode() {
            return this.groups;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof Version)) return false;
            Version other = (Version)((Object)obj);
            if (other.groups != this.groups) return false;
            return true;
        }
    }
}

